/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SingleInstanceFactory;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8260.MibAttribute;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.jdm8260.NicknameTable;
import ibm.nways.jdm8260.SummaryInfoLike;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MibInfo {
    public static final int NO_ERROR = 0;
    public static final int COMMUNICATIONS_PROBLEM = 1;
    public static final int WRONG_SYSOID = 2;
    public static final int DECODER_PROBLEM = 3;
    public static final int SUMMARY_TIMEOUT = 4;
    private Hashtable attributes = new Hashtable();
    private GenModel deviceModel;
    private NicknameTable nicknames;
    private SummaryInfoLike summary;
    private boolean errorDetected = false;
    private int reasonCode = 0;
    private ModelInfo lastModelInfo;
    private String lastInfoId;
    private static final Serializable nullObject = (Serializable)SingleInstanceFactory.getInstance("ibm.nways.jdm.common.Null");

    protected void finalize() throws Throwable {
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        this.deviceModel = null;
        this.summary = null;
    }

    public void dispose() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
        this.deviceModel = null;
        this.summary = null;
    }

    public synchronized void setModelAndNicknames(GenModel genModel, NicknameTable nicknameTable) {
        this.deviceModel = genModel;
        this.nicknames = nicknameTable;
    }

    public synchronized void setSummaryInfo(SummaryInfoLike summaryInfoLike) {
        String string = "setSummaryInfo";
        this.errorDetected = false;
        this.summary = summaryInfoLike;
        if (summaryInfoLike != null) {
            summaryInfoLike.setDeviceModel(this.deviceModel);
            summaryInfoLike.setMibInfo(this);
            summaryInfoLike.initialize();
            if (this.errorDetected && RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Error detected in MibInfo: " + this.reasonCode);
            }
        }
    }

    public synchronized boolean getErrorStatus() {
        return this.errorDetected;
    }

    public synchronized void setErrorCode(int n) {
        String string = "setErrorCode";
        this.errorDetected = true;
        this.reasonCode = n;
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, this, string, "Error detected: " + n);
        }
    }

    public synchronized int getErrorCode() {
        this.errorDetected = false;
        return this.reasonCode;
    }

    public synchronized void refreshSummaryInfo() {
        this.errorDetected = false;
        if (this.summary != null) {
            this.summary.refresh();
        }
    }

    public synchronized void clearSummaryInfo() {
        this.lastInfoId = null;
        this.lastModelInfo = null;
        this.attributes.clear();
    }

    private ModelInfo getModelInfo(String string) {
        String string2 = "getModelInfo";
        ModelInfo modelInfo = null;
        try {
            modelInfo = this.deviceModel.getInfo(string);
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string2, exception);
        }
        return modelInfo;
    }

    private Serializable getVarFromSummary(String string) {
        MibAttribute mibAttribute = (MibAttribute)this.attributes.get(string);
        if (mibAttribute != null) {
            Vector vector = mibAttribute.getValues();
            int n = vector.size();
            if (n == 0) {
                return nullObject;
            }
            return vector;
        }
        return nullObject;
    }

    private Serializable getVarFromModelInfo(ModelInfo modelInfo, String string, String string2) {
        Serializable serializable;
        if (modelInfo != null && (serializable = modelInfo.get(String.valueOf(string) + "." + string2)) != null) {
            return serializable;
        }
        return nullObject;
    }

    public synchronized Vector getVectorVar(String string) {
        String string2 = "getVectorVar";
        Vector<Serializable> vector = new Vector<Serializable>();
        if (!this.nicknames.find(string)) {
            return vector;
        }
        if (this.nicknames.isSummaryInfo()) {
            return vector;
        }
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent(this.nicknames.getInfoId());
            Vector vector2 = genModel.getRestOfInfo("Panel", "default", null, null);
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                if (modelInfo == null) continue;
                Serializable serializable = modelInfo.get("Panel." + this.nicknames.getAttributeId());
                if (serializable == null) {
                    vector.addElement(nullObject);
                    continue;
                }
                vector.addElement(serializable);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string2, exception);
        }
        return vector;
    }

    public synchronized Serializable getVectorVar(String string, String string2, String[] stringArray) {
        String string3 = "getVectorVar";
        if (!this.nicknames.find(string)) {
            return nullObject;
        }
        if (this.nicknames.isSummaryInfo()) {
            return nullObject;
        }
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent(this.nicknames.getInfoId());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            Integer[] integerArray = new Integer[n];
            n2 = 0;
            while (n2 < n) {
                integerArray[n2] = Integer.valueOf(stringTokenizer.nextToken());
                ++n2;
            }
            ModelInfo modelInfo = new ModelInfo();
            n2 = 0;
            while (n2 < stringArray.length) {
                modelInfo.add(stringArray[n2], integerArray[n2]);
                ++n2;
            }
            ModelInfo modelInfo2 = genModel.getInfo("Panel", "default", modelInfo);
            Serializable serializable = modelInfo2.get("Panel." + this.nicknames.getAttributeId());
            return serializable;
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string3, exception);
            return nullObject;
        }
    }

    public synchronized Serializable getVar(String string) {
        if (!this.nicknames.find(string)) {
            return nullObject;
        }
        if (this.nicknames.isSummaryInfo()) {
            return this.getVarFromSummary(this.nicknames.getSummaryInfoOid());
        }
        ModelInfo modelInfo = null;
        String string2 = this.nicknames.getInfoId();
        if (string2.equals(this.lastInfoId) && this.lastModelInfo != null) {
            modelInfo = this.lastModelInfo;
        } else {
            modelInfo = this.getModelInfo(string2);
            this.lastInfoId = string2;
            this.lastModelInfo = modelInfo;
        }
        return this.getVarFromModelInfo(modelInfo, string2, this.nicknames.getAttributeId());
    }

    public synchronized Serializable getVarNext(String string, String string2) {
        if (string2 == null || "".equals(string2)) {
            return this.getVarFirst(string);
        }
        Serializable serializable = this.getVar(string);
        if (serializable instanceof Vector) {
            Vector vector = (Vector)serializable;
            int n = vector.indexOf(new MibValue(string2, null));
            if (n == -1) {
                return nullObject;
            }
            if (++n < vector.size()) {
                return (Serializable)vector.elementAt(n);
            }
            return nullObject;
        }
        return nullObject;
    }

    public synchronized Serializable getVarFirst(String string) {
        Serializable serializable = this.getVar(string);
        if (serializable instanceof Vector) {
            Vector vector = (Vector)serializable;
            if (vector.size() == 0) {
                return nullObject;
            }
            return (Serializable)vector.firstElement();
        }
        return nullObject;
    }

    public synchronized Serializable getVar(String string, String string2) {
        if (!this.nicknames.find(string)) {
            return nullObject;
        }
        if (!this.nicknames.isSummaryInfo()) {
            return nullObject;
        }
        Serializable serializable = this.getVarFromSummary(this.nicknames.getSummaryInfoOid());
        if (serializable instanceof Vector) {
            Vector vector = (Vector)serializable;
            int n = vector.indexOf(new MibValue(string2, null));
            if (n == -1) {
                return nullObject;
            }
            return (Serializable)vector.elementAt(n);
        }
        return nullObject;
    }

    public synchronized Vector getVar(String[] stringArray, String[] stringArray2) {
        Vector<Serializable> vector = new Vector<Serializable>();
        if (stringArray.length == 0 || stringArray2.length == 0 || stringArray.length != stringArray2.length) {
            return vector;
        }
        ModelInfo modelInfo = null;
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (!this.nicknames.find(stringArray[n])) {
                vector.addElement(nullObject);
            } else if (this.nicknames.isSummaryInfo()) {
                vector.addElement(this.getVar(stringArray[n], stringArray2[n]));
            } else {
                if (string != null) {
                    if (!string.equals(this.nicknames.getInfoId())) {
                        modelInfo = this.getModelInfo(this.nicknames.getInfoId());
                        string = this.nicknames.getInfoId();
                    }
                } else {
                    modelInfo = this.getModelInfo(this.nicknames.getInfoId());
                    string = this.nicknames.getInfoId();
                }
                if (modelInfo == null) {
                    vector.addElement(nullObject);
                } else {
                    vector.addElement(this.getVarFromModelInfo(modelInfo, this.nicknames.getInfoId(), this.nicknames.getAttributeId()));
                }
            }
            ++n;
        }
        return vector;
    }

    public synchronized void addVar(String string, MibValue mibValue) {
        MibAttribute mibAttribute = (MibAttribute)this.attributes.get(string);
        if (mibAttribute == null) {
            mibAttribute = new MibAttribute(string);
            mibAttribute.addValue(mibValue);
            this.attributes.put(string, mibAttribute);
            return;
        }
        mibAttribute.addValue(mibValue);
    }
}

